from netmiko import ConnectHandler
import getpass

rtr_command = input("Enter the IOS-XE router show command that you want to display?")

def rtr_function(dev):
    dev.send_command("terminal length 0")
    output = dev.send_command(rtr_command)
    hostname = dev.send_command("show run | include hostname").split()[1]
    print(f"*****This is the output of {hostname}*****")
    print(output)
    print("\n")
    dev.disconnect()

uname = input("Please enter you Username")
passwd = getpass.getpass("Please enter you Password")

r19 = ConnectHandler(ip="192.168.122.19", username=uname, password=passwd, device_type="cisco_xe")
r20 = ConnectHandler(ip="192.168.122.20", username=uname, password=passwd, device_type="cisco_xe")
r21 = ConnectHandler(ip="192.168.122.21", username=uname, password=passwd, device_type="cisco_xe")
r29 = ConnectHandler(ip="192.168.122.29", username=uname, password=passwd, device_type="cisco_xe")
r30 = ConnectHandler(ip="192.168.122.30", username=uname, password=passwd, device_type="cisco_xe")
r31 = ConnectHandler(ip="192.168.122.31", username=uname, password=passwd, device_type="cisco_xe")

devices = [r19, r20, r21, r29, r30, r31]

for item in devices:
    rtr_function(item)


    
